<?php
/**
 * @package 	OT Brand Map Module for Joomla! 3.3
 * @version 	$Id: mod_maps.php - Mar 2015 00:00:00Z OmegaTheme
 * @author 		OmegaTheme Extensions (services@omegatheme.com) - http://omegatheme.com
 * @copyright	Copyright(C) 2015 - OmegaTheme Extensions
 * @license 	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
**/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldOtmaps extends JFormField
{
	protected $type = 'Otmaps';
	protected function getInput()
	{
    // Initialize variables.
	
      JFactory::getDocument()->addStyleSheet(JURI::root().'modules/mod_otbrandmaps/assets/css/mod_otmaps.css');
		JFactory::getDocument()->addScript('https://maps.googleapis.com/maps/api/js?sensor=false?v=3.exp&signed_in=true&libraries=places');
      JHtml::_('behavior.framework');
      JHtml::_('behavior.modal');	  		
      $html = array();

      $class = !empty($this->class) ? ' class="' . $this->class . '"' : '';
      $disabled = $this->disabled ? ' disabled' : '';

      // Initialize JavaScript field attributes.
      $onchange = $this->onchange ? ' onchange="' . $this->onchange . '"' : '';

      $html[] = '
	  <div class="tabs">'.$this->getTabsInput().'</div>
	  <a class="tabAdd btn button btn-success" href="#"><span class="icon-plus"></span> </a>
	  <div class="clearfix"></div>
	  <style>
		.ot-map-canvas,.ot-map {
		width: 1000px; height: 450px;
		float:left;
		}
		</style>
		<script type="text/javascript"> 
		//<![CDATA[

			 // global "map" variable
			  var map = null;
			  var marker = null;

		var infowindow = new google.maps.InfoWindow(
		  { 
			size: new google.maps.Size(150,50)
		  });

		// A function to create the marker and set up the event window function 
		function createMarker(latlng, name, html) {
			var contentString = html;
			var marker = new google.maps.Marker({
				position: latlng,
				map: map,
				zIndex: Math.round(latlng.lat()*-100000)<<5
				});

			google.maps.event.addListener(marker, "click", function() {
				infowindow.setContent(contentString); 
				infowindow.open(map,marker);
				});
			google.maps.event.trigger(marker, "click");    
			return marker;
		}
		function initialize() {
		  // create the map
		  var myOptions = {
			zoom: 8,
			center: new google.maps.LatLng(43.907787,-79.359741),
			mapTypeControl: true,
			mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU},
			navigationControl: true,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		  }
		  map = new google.maps.Map(document.getElementById("map-canvas"),
										myOptions);
		  google.maps.event.addListener(map, "click", function() {
				infowindow.close();
				});

		  google.maps.event.addListener(map, "click", function(event) {
			//call function to create marker
				 if (marker) {
					marker.setMap(null);
					marker = null;
				 }
			 marker = createMarker(event.latLng, "name", "<b>Location</b><br>"+event.latLng);
			 var a=event.latLng.lat();
			 a1=a.toPrecision(8);
			 var b=event.latLng.lng();
			 b1=b.toPrecision(8);
			 document.getElementById("ot-lat").value = a1;
			 document.getElementById("ot-lng").value = b1;
		  });
		  
		  var markers = [];

		   var input = /** @type {HTMLInputElement} */(
			  document.getElementById("pac-input"));
		   var searchBox = new google.maps.places.SearchBox(
			/** @type {HTMLInputElement} */(input));

		  // [START region_getplaces]
		  // Listen for the event fired when the user selects an item from the
		  // pick list. Retrieve the matching places for that item.
		  google.maps.event.addListener(searchBox, "places_changed", function() {
			var places = searchBox.getPlaces();

			if (places.length == 0) {
			  return;
			}
			for (var i = 0, marker; marker = markers[i]; i++) {
			  marker.setMap(null);
			}

			// For each place, get the icon, place name, and location.
			markers = [];
			var bounds = new google.maps.LatLngBounds();
			for (var i = 0, place; place = places[i]; i++) {
			  var image = {
				url: place.icon,
				size: new google.maps.Size(71, 71),
				origin: new google.maps.Point(0, 0),
				anchor: new google.maps.Point(17, 34),
				scaledSize: new google.maps.Size(25, 25)
			  };

			  // Create a marker for each place.
			  var marker = new google.maps.Marker({
				map: map,
				icon: image,
				title: place.name,
				position: place.geometry.location
			  });

			  markers.push(marker);

			  bounds.extend(place.geometry.location);
			}

			map.fitBounds(bounds);
		  });
		}

		google.maps.event.addDomListener(window, "load", initialize);
		//]]>
		</script> 
		<div class="ot-map"  onload="initialize()"> 
			<input id="pac-input" class="ot-controls"   type="text" placeholder="Search Box">
			<span>latitude </span><input id="ot-lat" class="ot-controls"   type="text" />
			<span>longitude</span><input id="ot-lng" class="ot-controls"   type="text" />
		   <div id="map-canvas" class="ot-map-canvas" style=""></div> 
		</div> 
        
        <div id="tabs-template" class="hidden">'.$this->getTabsInput(true).'</div>
        
        
        ';

      JFactory::getDocument()->addScriptDeclaration($this->getScript());
      return implode($html);
  }	
  protected function getTabsInput($is_template = false)
  {
	 
		
    $html = array();
    if ($is_template){
      $html[] = '
        <div class="tab">
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_LAT_DESC').'">'.JText::_('MOD_OTMAP_FIELD_LAT_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][lat]', $this->id .'_REPLACE_lat','').'
          </div>  
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_LNG_DESC').'">'.JText::_('MOD_OTMAP_FIELD_LNG_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][lng]', $this->id .'_REPLACE_lng','').'
          </div>
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_ICON_DESC').'">'.JText::_('MOD_OTMAP_FIELD_ICON_LABEL').'</label>
          '.$this->getInputMedia($this->name.'[REPLACE][icon]', $this->id.'_REPLACE_icon', '').'
          </div>
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_IMAGE_DESC').'">'.JText::_('MOD_OTMAP_FIELD_IMAGE_LABEL').'</label>
          '.$this->getInputMedia($this->name.'[REPLACE][image]', $this->id.'_REPLACE_image', '').'
          </div>
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_AREA_DESC').'">'.JText::_('MOD_OTMAP_FIELD_AREA_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][area]', $this->id .'_REPLACE_area','').'
          </div> 
                 
          <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_NAME_DESC').'">'.JText::_('MOD_OTMAP_FIELD_NAME_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][name]', $this->id.'_REPLACE_name', '').'
          </div>
          <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_ADDRESS_DESC').'">'.JText::_('MOD_OTMAP_FIELD_ADDRESS_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][address]', $this->id.'_REPLACE_address', '').'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_PHONE_DESC').'">'.JText::_('MOD_OTMAP_FIELD_PHONE_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][phone]', $this->id.'_REPLACE_phone', '').'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_WEB_DESC').'">'.JText::_('MOD_OTMAP_FIELD_WEB_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][web]', $this->id.'_REPLACE_web', '').'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_EMAIL_DESC').'">'.JText::_('MOD_OTMAP_FIELD_EMAIL_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][email]', $this->id.'_REPLACE_email', '').'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_FAX_DESC').'">'.JText::_('MOD_OTMAP_FIELD_FAX_LABEL').'</label>
          '.$this->getInputText($this->name.'[REPLACE][fax]', $this->id.'_REPLACE_fax', '').'
          </div>
          <div class="clearfix"></div>
          <a class="tabRemove btn btn-small" href="#"><span class="icon-cancel"></span> </a>
        </div>
        <div class="clearfix"></div>
      ';
    } else {
      if (!empty($this->value)){
        for ($i = 0; $i < count($this->value); $i++){
          if (!empty($this->value[$i]['address']))
			
			/*@$image1 =end(explode("/",$this->value[$i]['image']));
			$images = JUri::root().''.$this->value[$i]['image'];
			$img = new SimpleImage();
			$a=$img->resize_image('crop',$images,'gdfgdfgdf.jpg',100,100);
			
			// Strip exif data (just load and save)
			//$this->load($images);
			var_dump($a);
			/var_dump($img->load($this->value[$i]['image']));
		   $img->resize(250,400);
		   $img->save(JUri::root().'images/cache/'.$image.'');
		   //var_dump($img->save('picture2.jpg'));*/
          $html[] = '
        <div class="tab">
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_LAT_DESC').'">'.JText::_('MOD_OTMAP_FIELD_LAT_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][lat]', $this->id .'_'.$i.'_lat', $this->value[$i]['lat']).'
          </div> 
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_LNG_DESC').'">'.JText::_('MOD_OTMAP_FIELD_LNG_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][lng]', $this->id .'_'.$i.'_lng', $this->value[$i]['lng']).'
          </div> 
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_ICON_DESC').'">'.JText::_('MOD_OTMAP_FIELD_ICON_LABEL').'</label>
          '.$this->getInputMedia($this->name.'['.$i.'][icon]', $this->id.'_'.$i.'_icon',$this->value[$i]['icon']).'
          </div> 
		   <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_IMAGE_DESC').'">'.JText::_('MOD_OTMAP_FIELD_IMAGE_LABEL').'</label>
          '.$this->getInputMedia($this->name.'['.$i.'][image]', $this->id.'_'.$i.'_image',$this->value[$i]['image']).'
          </div> 
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_AREA_DESC').'">'.JText::_('MOD_OTMAP_FIELD_AREA_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][area]', $this->id .'_'.$i.'_area', $this->value[$i]['area']).'
          </div>         
          <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_NAME_DESC').'">'.JText::_('MOD_OTMAP_FIELD_NAME_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][name]', $this->id. '_'.$i.'_name', $this->value[$i]['name']).'
          </div>
          <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_ADDRESS_DESC').'">'.JText::_('MOD_OTMAP_FIELD_ADDRESS_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][address]', $this->id. '_'.$i.'_address', $this->value[$i]['address']).'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_PHONE_DESC').'">'.JText::_('MOD_OTMAP_FIELD_PHONE_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][phone]', $this->id. '_'.$i.'_phone', $this->value[$i]['phone']).'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_WEB_DESC').'">'.JText::_('MOD_OTMAP_FIELD_WEB_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][web]', $this->id. '_'.$i.'_web', $this->value[$i]['web']).'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_EMAIL_DESC').'">'.JText::_('MOD_OTMAP_FIELD_EMAIL_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][email]', $this->id. '_'.$i.'_email', $this->value[$i]['email']).'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_FAX_DESC').'">'.JText::_('MOD_OTMAP_FIELD_FAX_LABEL').'</label>
          '.$this->getInputText($this->name.'['.$i.'][fax]', $this->id. '_'.$i.'_email', $this->value[$i]['fax']).'
          </div>
          <a class="tabRemove btn btn-small" href="#"><span class="icon-cancel"></span> </a>
        </div>
        <div class="clearfix"></div>
          ';
        }
      }
      else {
        $html[] = '
        <div class="tab">
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_LAT_DESC').'">'.JText::_('MOD_OTMAP_FIELD_LNG_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][lat]', $this->id.'_0_lat', '').'
          </div>  
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_LNG_DESC').'">'.JText::_('MOD_OTMAP_FIELD_LNG_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][lng]', $this->id.'_0_lng', '').'
          </div>  
		   <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_ICON_DESC').'">'.JText::_('MOD_OTMAP_FIELD_ICON_LABEL').'</label>
          '.$this->getInputMedia($this->name.'[0][icon]', $this->id.'_0_icon','').'
          </div> 
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_AREA_DESC').'">'.JText::_('MOD_OTMAP_FIELD_AREA_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][area]', $this->id.'_0_area', '').'
          </div>         
          <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_NAME_DESC').'">'.JText::_('MOD_OTMAP_FIELD_NAME_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][name]', $this->id.'_0_name', '').'
          </div> 
          <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_ADDRESS_DESC').'">'.JText::_('MOD_OTMAP_FIELD_ADDRESS_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][address]', $this->id.'_0_address', '').'
          </div>
		   <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_PHONE_DESC').'">'.JText::_('MOD_OTMAP_FIELD_PHONE_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][phone]', $this->id.'_0_phone', '').'
          </div>
			<div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_WEB_DESC_DESC').'">'.JText::_('MOD_OTMAP_FIELD_WEB_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][web]', $this->id.'_0_web', '').'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_EMAIL_DESC_DESC').'">'.JText::_('MOD_OTMAP_FIELD_EMAIL_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][email]', $this->id.'_0_email', '').'
          </div>
		  <div class="col">
          <label class="hasTooltip" title="'.JHtml::tooltipText('MOD_OTMAP_FIELD_FAX_DESC_DESC').'">'.JText::_('MOD_OTMAP_FIELD_FAX_LABEL').'</label>
          '.$this->getInputText($this->name.'[0][fax]', $this->id.'_0_fax', '').'
          </div>
          <a class="tabRemove btn btn-small" href="#"><span class="icon-cancel"></span> </a>
        </div>
        <div class="clearfix"></div>
        ';
      }
    }
    return implode($html);
  }


  protected function getInputText($name, $id, $value = '')
  {
    return '<input type="text" value="'.htmlspecialchars($value, ENT_COMPAT, 'UTF-8').'" id="'.$id.'" name="'.$name.'" class="" aria-required="true" />';
  }

  protected function getInputMedia($name, $id, $value = '')
  {

    $html = array();
    $html[] = '<div class="input-prepend input-append">';

    // The Preview.
		$showPreview = true;
		$showAsTooltip = true;
    $options = array(
      'onShow' => 'jMediaRefreshPreviewTip',
    );
    JHtml::_('behavior.tooltip', '.hasTipPreview', $options);

    if ($showPreview)
		{
			if ($value && file_exists(JPATH_ROOT . '/' . $value))
			{
				$src = JUri::root() . $value;
			}
			else
			{
				$src = '';
			}

			$width = 300;
			$height = 200;
			$style = '';
			$style .= ($width > 0) ? 'max-width:' . $width . 'px;' : '';
			$style .= ($height > 0) ? 'max-height:' . $height . 'px;' : '';

			$imgattr = array(
				'id' => $id . '_preview',
				'class' => 'media-preview',
				'style' => $style,
				
			);

			$img = JHtml::image($src, JText::_('JLIB_FORM_MEDIA_PREVIEW_ALT'), $imgattr);
			$previewImg = '<div id="' . $id . '_preview_img"' . ($src ? '' : ' style="display:none"') . '>' . $img . '</div>';
			$previewImgEmpty = '<div id="' . $id . '_preview_empty"' . ($src ? ' style="display:none"' : '') . '>'
				. JText::_('JLIB_FORM_MEDIA_PREVIEW_EMPTY') . '</div>';

			if ($showAsTooltip)
			{
				$html[] = '<div class="media-preview add-on">';
				$tooltip = $previewImgEmpty . $previewImg;
				$options = array(
					'title' => JText::_('JLIB_FORM_MEDIA_PREVIEW_SELECTED_IMAGE'),
					'text' => '<i class="icon-eye"></i>',
					'class' => 'hasTipPreview'
				);

				$html[] = JHtml::tooltip($tooltip, $options);
				$html[] = '</div>';
			}
			else
			{
				$html[] = '<div class="media-preview add-on" style="height:auto">';
				$html[] = ' ' . $previewImgEmpty;
				$html[] = ' ' . $previewImg;
				$html[] = '</div>';
			} 
    }
    $html[] = '	<input directory="icon-marker" class="" type="text" name="' . $name . '" id="' . $id . '" value="'
			. htmlspecialchars($value, ENT_COMPAT, 'UTF-8') . '" readonly="readonly" />';

    $html[] = '<a  class="modal btn" title="' . JText::_('JLIB_FORM_BUTTON_SELECT') . '" href="index.php?option=com_media&amp;view=images&amp;tmpl=component&amp;fieldid=' . $id . '"'
				. ' rel="{handler: \'iframe\', size: {x: 800, y: 500}}">';
    $html[] = JText::_('JLIB_FORM_BUTTON_SELECT') . '</a><a class="btn hasTooltip" title="' . JText::_('JLIB_FORM_BUTTON_CLEAR') . '" href="#" onclick="';
    $html[] = 'jInsertFieldValue(\'\', \'' . $id . '\');';
    $html[] = 'return false;';
    $html[] = '">';
    $html[] = '<i class="icon-remove"></i></a>';
    $html[] = '</div>';
    return implode("\n", $html);
  }

  protected function getScript()
  {
    $html = array();

    $html[] = '

        jQuery(document).ready(function($){

          reloadValidator = function () {
            if(document.formvalidator == null) {
              document.formvalidator = new JFormValidator(jQuery.noConflict());
            }
            //document.formvalidator.initialize();
          }

          resetSelectChosen = function (clone) {
            // Chosen reset
            $(clone).find("select").removeClass("chzn-done").show();

            // Assign random id
            //$.each($(clone).find("select"), function (index, c) {
            //    c.id = c.id + "_" + (Math.random() * 10000000).toInt();
            //});

            $(clone).find(".chzn-container").remove();

            $("select").chosen({
                disable_search_threshold : 10,
                allow_single_deselect : true
            });
          };

          addTab = function () {
            var container = $(".tabs")[0];
            var count = $(container).children(".tab").length;
            var clone = $("#tabs-template").find(".tab").clone(true, true);

            clone.appendTo(container);
            var contentClone = $(clone).html();
            contentClone = contentClone.replace(/REPLACE/ig, count);
            $(clone).html(contentClone);

            resetSelectChosen(clone);
            reloadValidator();
            reInitModal();
            $(".hasTooltip").tooltip({"html": true,"container": "body"});
          }

          removeTab = function (el) {
            $(el).remove();
            updateTabs();
          }

          updateTabs = function () {
            $(".tabs .tab").each(function(index, element){
              // method 1: replace all of the string
              //var originalContent = $(element).html();
              //originalContent = originalContent.replace(/\[[0-9]\]/g, "[" + index + "]");
              //originalContent = originalContent.replace(/\_[0-9]/g, "_" + index);
              //$(element).html(originalContent);

              // method 2: replace name and id of element
              $(element).find("input, select").each(function(id, el){
                el.name = el.name.replace(/\[[0-9]\]/, "[" + index + "]");
                el.id = el.id.replace(/_[0-9]/, "_" + index);
              });

              resetSelectChosen(element);
            });
            reloadValidator();
          }

          $("#tabs-template").appendTo($("body"));

          $(document).on( "click", "a.tabAdd", function(e){
            e.preventDefault();
            addTab();
          });

          $(document).on( "click", "a.tabRemove", function(e){
            e.preventDefault();
            removeTab($(this).parent(".tab"));
          });

        });

        function reInitModal(){
          SqueezeBox.initialize({});
          SqueezeBox.assign($$("a.modal"), {
            parse: "rel"
          });
        }

        function jInsertFieldValue(value, id) {
          var old_value = document.id(id).value;
          if (old_value != value) {
            var elem = document.id(id);
            elem.value = value;
            elem.fireEvent("change");
            if (typeof(elem.onchange) === "function") {
              elem.onchange();
            }
            jMediaRefreshPreview(id);
          }
        }

        function jMediaRefreshPreview(id) {
          var value = document.id(id).value;
          var img = document.id(id + "_preview");
          if (img) {
            if (value) {
              img.src = "' . JUri::root() . '" + value;
              document.id(id + "_preview_empty").setStyle("display", "none");
              document.id(id + "_preview_img").setStyle("display", "");
            } else {
              img.src = ""
              document.id(id + "_preview_empty").setStyle("display", "");
              document.id(id + "_preview_img").setStyle("display", "none");
            }
          }
        }

        function jMediaRefreshPreviewTip(tip)
        {
          var img = tip.getElement("img.media-preview");
          tip.getElement("div.tip").setStyle("max-width", "none");
          var id = img.getProperty("id");
          id = id.substring(0, id.length - "_preview".length);
          jMediaRefreshPreview(id);
          tip.setStyle("display", "block");
        }
    ';

    return implode("\n", $html);
  }
}
